---
-- Name: AID-008 - AI_A2A - CAP Grouping Test
-- Author: FlightControl
-- Date Created: 06 Aug 2017


-- Define a SET_GROUP object that builds a collection of groups that define the EWR network.
-- Here we build the network with all the groups that have a name starting with DF CCCP AWACS and DF CCCP EWR.
--DetectionSetGroup = SET_GROUP:New()
--DetectionSetGroup:FilterPrefixes("DARKSTAR", "WIZARD")
--DetectionSetGroup:FilterStart()
--Detection = DETECTION_AREAS:New( DetectionSetGroup, 1000)
DetectionSetGroup_NEUTRAL = SET_GROUP:New()
DetectionSetGroup_NEUTRAL:FilterPrefixes("107", "109" ,"REDEWR", "DARKSTAR", "WIZARD" , "BLUEEWR")
DetectionSetGroup_NEUTRAL:FilterStart()
Detection_NEUTRAL = DETECTION_AREAS:New( DetectionSetGroup_NEUTRAL, 300000 )

A2ADispatcher_NEUTRAL = AI_A2A_DISPATCHER:New( Detection_NEUTRAL )
A2ADispatcher_NEUTRAL:SetEngageRadius( 1 )
A2ADispatcher_NEUTRAL = AI_A2A_DISPATCHER:New( Detection_NEUTRAL )
--A2ADispatcher:SetEngageRadius( 10 )
	
IRANCHESSNEUTRALFZ = ZONE_POLYGON:New( "IRANCHESSNEUTRALFZ", GROUP:FindByName( "IRANCHESSNEUTRALFZ" ) )
A2ADispatcher_NEUTRAL:SetBorderZone( {IRANCHESSNEUTRALFZ} )

--------------------////CAP Squadrons 
A2ADispatcher_NEUTRAL:SetSquadron( "KishNEUTRAL", AIRBASE.PersianGulf.Kish_International_Airport, { "An26B", "An30M", "Yak40", "Yak52" } )
A2ADispatcher_NEUTRAL:SetSquadron( "ShirazNEUTRAL", AIRBASE.PersianGulf.Shiraz_International_Airport, { "An26B", "An30M", "Yak40", "Yak52" } )
A2ADispatcher_NEUTRAL:SetSquadron( "KermanNEUTRAL", AIRBASE.PersianGulf.Kerman_Airport, { "An26B", "An30M", "Yak40", "Yak52" } )
A2ADispatcher_NEUTRAL:SetSquadron( "BandarNEUTRAL", AIRBASE.PersianGulf.Bandar_Abbas_Intl, { "An26B", "An30M", "Yak40", "Yak52" } )
A2ADispatcher_NEUTRAL:SetSquadron( "DubaiNEUTRAL", AIRBASE.PersianGulf.Dubai_Intl, { "An26B", "An30M", "Yak40", "Yak52" } )

--These are all airbases of the Persion Gulf Map:

--AIRBASE.PersianGulf.Abu_Dhabi_International_Airport
--AIRBASE.PersianGulf.Abu_Musa_Island_Airport
--AIRBASE.PersianGulf.Al-Bateen_Airport
--AIRBASE.PersianGulf.Al_Ain_International_Airport
--AIRBASE.PersianGulf.Al_Dhafra_AB
--AIRBASE.PersianGulf.Al_Maktoum_Intl
--AIRBASE.PersianGulf.Al_Minhad_AB
--AIRBASE.PersianGulf.Bandar_e_Jask_airfield
--AIRBASE.PersianGulf.Bandar_Abbas_Intl
--AIRBASE.PersianGulf.Bandar_Lengeh
--AIRBASE.PersianGulf.Dubai_Intl
--AIRBASE.PersianGulf.Fujairah_Intl
--AIRBASE.PersianGulf.Havadarya
--AIRBASE.PersianGulf.Jiroft_Airport
--AIRBASE.PersianGulf.Kerman_Airport
--AIRBASE.PersianGulf.Khasab
--AIRBASE.PersianGulf.Kish_International_Airport
--AIRBASE.PersianGulf.Lar_Airbase
--AIRBASE.PersianGulf.Lavan_Island_Airport
--AIRBASE.PersianGulf.Liwa_Airbase
--AIRBASE.PersianGulf.Qeshm_Island
--AIRBASE.PersianGulf.Ras_Al_Khaimah_International_Airport
--AIRBASE.PersianGulf.Sas_Al_Nakheel_Airport
--AIRBASE.PersianGulf.Sharjah_Intl
--AIRBASE.PersianGulf.Shiraz_International_Airport
--AIRBASE.PersianGulf.Sir_Abu_Nuayr
--AIRBASE.PersianGulf.Sirri_Island
--AIRBASE.PersianGulf.Tunb_Island_AFB
--AIRBASE.PersianGulf.Tunb_Kochak

--------------------////TAKEOFF
A2ADispatcher_NEUTRAL:SetSquadronTakeoffFromParkingCold( "KishNEUTRAL" )
A2ADispatcher_NEUTRAL:SetSquadronTakeoffFromParkingCold( "ShirazNEUTRAL" )
A2ADispatcher_NEUTRAL:SetSquadronTakeoffFromParkingCold( "KermanNEUTRAL" )
A2ADispatcher_NEUTRAL:SetSquadronTakeoffFromParkingCold( "BandarNEUTRAL" )
A2ADispatcher_NEUTRAL:SetSquadronTakeoffFromParkingCold( "DubaiNEUTRAL" )



--------------------////LANDING
A2ADispatcher_NEUTRAL:SetSquadronLandingAtEngineShutdown( "KishNEUTRAL" )
A2ADispatcher_NEUTRAL:SetSquadronLandingAtEngineShutdown( "ShirazNEUTRAL" )
A2ADispatcher_NEUTRAL:SetSquadronLandingAtEngineShutdown( "KermanNEUTRAL" )
A2ADispatcher_NEUTRAL:SetSquadronLandingAtEngineShutdown( "BandarNEUTRAL" )
A2ADispatcher_NEUTRAL:SetSquadronLandingAtEngineShutdown( "DubaiNEUTRAL" )



--------------------Timing Originally 300/750
A2ADispatcher_NEUTRAL:SetSquadronCap( "KishNEUTRAL", IRANCHESSNEUTRALFZ, 3000, 12000, 800, 1100, 1000, 1500, "BARO" )
A2ADispatcher_NEUTRAL:SetSquadronCapInterval( "KishNEUTRAL", 1, 1, 900, 1 )

A2ADispatcher_NEUTRAL:SetSquadronCap( "ShirazNEUTRAL", IRANCHESSNEUTRALFZ, 3000, 12000, 800, 1100, 1000, 1500, "BARO" )
A2ADispatcher_NEUTRAL:SetSquadronCapInterval( "ShirazNEUTRAL", 1, 1, 300, 1 )

A2ADispatcher_NEUTRAL:SetSquadronCap( "KermanNEUTRAL", IRANCHESSNEUTRALFZ, 3000, 12000, 800, 1100, 1000, 1500, "BARO" )
A2ADispatcher_NEUTRAL:SetSquadronCapInterval( "KermanNEUTRAL", 1, 1, 2500, 1 )

A2ADispatcher_NEUTRAL:SetSquadronCap( "BandarNEUTRAL", IRANCHESSNEUTRALFZ, 3000, 12000, 800, 1100, 1000, 1500, "BARO" )
A2ADispatcher_NEUTRAL:SetSquadronCapInterval( "BandarNEUTRAL", 1, 1, 700, 1 )

A2ADispatcher_NEUTRAL:SetSquadronCap( "DubaiNEUTRAL", IRANCHESSNEUTRALFZ, 3000, 12000, 800, 1100, 1000, 1500, "BARO" )
A2ADispatcher_NEUTRAL:SetSquadronCapInterval( "DubaiNEUTRAL", 2, 1, 3000, 1 )



--------------------////SQUADRON GROUPING
A2ADispatcher_NEUTRAL:SetSquadronGrouping( "KishNEUTRAL", 1 )
A2ADispatcher_NEUTRAL:SetSquadronGrouping( "ShirazNEUTRAL", 1 )
A2ADispatcher_NEUTRAL:SetSquadronGrouping( "KermanNEUTRAL", 1 )
A2ADispatcher_NEUTRAL:SetSquadronGrouping( "BandarNEUTRAL", 1 )
A2ADispatcher_NEUTRAL:SetSquadronGrouping( "DubaiNEUTRAL", 1 )


--------------------////SQUADRON OVERHEAD (1.0-1.5)
A2ADispatcher_NEUTRAL:SetSquadronOverhead( "KishNEUTRAL", 0.30)
A2ADispatcher_NEUTRAL:SetSquadronOverhead( "ShirazNEUTRAL", 0.30)
A2ADispatcher_NEUTRAL:SetSquadronOverhead( "KermanNEUTRAL", 0.30)
A2ADispatcher_NEUTRAL:SetSquadronOverhead( "BandarNEUTRAL", 0.30)
A2ADispatcher_NEUTRAL:SetSquadronOverhead( "DubaiNEUTRAL", 0.30)


A2ADispatcher_NEUTRAL:SetSquadronFuelThreshold( "KishNEUTRAL", 0.30 )
A2ADispatcher_NEUTRAL:SetSquadronFuelThreshold( "ShirazNEUTRAL", 0.30 )
A2ADispatcher_NEUTRAL:SetSquadronFuelThreshold( "KermanNEUTRAL", 0.30 )
A2ADispatcher_NEUTRAL:SetSquadronFuelThreshold( "BandarNEUTRAL", 0.30 )
A2ADispatcher_NEUTRAL:SetSquadronFuelThreshold( "DubaiNEUTRAL", 0.30 )
